/*
  EnOceanMsg.cpp - Library for flashing EnOceanMsg code.
  Created by David A. Mellis, November 2, 2007.
  Released into the public domain.
*/

#include "Arduino.h"
#include "EnOceanMsg.h"

EnOceanMsg::EnOceanMsg()
{
  reset();
}

void EnOceanMsg::reset()
{
  _dataLength1 = 0;
  _dataLength2 = 0;
  _optLength = 0;
  _packetType = 0;
  _headerCrc8 = 0;
  _org = 0;
  _payload = 0;
  _senderId1 = 0;
  _senderId2 = 0;
  _senderId3 = 0;
  _senderId4 = 0;
  _dataReceived = false;
}

uint16_t EnOceanMsg::getPacketLength() {
    //_dataLength1=0x45;
    //_dataLength2=0xA1;
	return ((uint16_t(_dataLength1) << 8) & 0xffff) + (_dataLength2 & 0xff);
}

int EnOceanMsg::getPayload(){
return _payload;
}

bool EnOceanMsg::dataAvailable()
{
return _dataReceived;
}

uint32_t EnOceanMsg::getSenderId() {
    //_senderId1=0x45;
    //_senderId2=0x46;
    //_senderId3=0x47;
    //_senderId4=0x48;
    uint32_t aResponse = ((uint32_t(_senderId1) << 24) & 0xffffffff) + ((uint32_t(_senderId2)  << 16) & 0xffffffff) + ((uint32_t(_senderId3) << 8) & 0xffffffff) + (uint32_t(_senderId4) & 0xffffffff);
	return aResponse;
}

/*void EnOceanMsg::prettyPrint()
{
debug("Pretty print start");

debug("length:");
char buf1[9];
sprintf(buf1, "%04x", getPacketLength());
debug(buf1);
//debug(getPacketLength());

debug("Optional length:");
debug(_optLength);

debug("Packet type:0x");
debug(_packetType, HEX);

debug("ORG:0x");
debug(_org, HEX);

debug("Payload:0x");
debug(_payload, HEX);

debug("Sender Id:");
char buf[20];
sprintf(buf, "%lx", getSenderId());
debug(buf);
//debug(getSenderId(), HEX);

debug("Pretty print end");
}
*/
void EnOceanMsg::decode()
{
  //debug("Entering");
  while(Serial.available() > 0)
  {
  //debug("Decoding");
  _dataReceived=true;
    uint8_t aChar = Serial.read();
    switch(_pos) 
  {
			case 0:
		        if (aChar == START_BYTE) 
                {
		        	_pos++;
                    //debug("START");
		        }
                break;
                
                case 1:
				// length msb
				_dataLength1=aChar;
				_pos++;
                //debug("length msb:");
                //debug(_dataLength1, HEX);
				break;
                
			case 2:
				// length lsb
				_dataLength2=aChar;
				_pos++;
                //debug("length lsb:");
                //debug(_dataLength2, HEX);
				break;
                
                case 3:
				// length lsb
				_optLength=aChar;
				_pos++;
                //debug("_optLength lsb:");
                //debug(_optLength, HEX);
				break;
                
                case 4:
				// length lsb
				_packetType=aChar;
				_pos++;
                //debug("_packetType lsb:");
                //debug(_packetType, HEX);
				break;
                
                case 5:
				// length lsb
				_headerCrc8=aChar;
				_pos++;
                //debug("_headerCrc8 lsb:");
                //debug(_headerCrc8, HEX);
				break;
                
                case 6:
				// length lsb
				_org=aChar;
				_pos++;
                //debug("_headerCrc8 lsb:");
                //debug(_headerCrc8, HEX);
				break;
                
                case 7:
				// length lsb
				_payload=aChar;
				_pos++;
                //debug("_headerCrc8 lsb:");
                //debug(_headerCrc8, HEX);
				break;
                
                
                case 8:
				_senderId1=aChar;
				_pos++;
                //debug("_senderId1:");
                //debug(_senderId1, HEX);
				break;
                
                case 9:
				_senderId2=aChar;
				_pos++;
                //debug("_senderId2:");
                //debug(_senderId2, HEX);
				break;
                
                case 10:
				_senderId3=aChar;
				_pos++;
                //debug("_senderId3:");
                //debug(_senderId3, HEX);
				break;
                
                case 11:
				_senderId4=aChar;
				_pos++;
                //debug("_senderId4:");
                //debug(_senderId4, HEX);
				break;
                
                default:
                //debug("Data: 0x");
                _pos++;
    //debug(aChar, HEX);
                }
                
                
  }
  if (_pos != 0)
  {
  

  //prettyPrint();
  }
  _pos=0;
}
